data{
    int n;
    vector[n] x;
    vector[n] y;
}
parameters{
    real beta0;
    real beta1;

}
transformed parameters{
    vector[n] mu;
    {
        for(i in 1:n){
            mu[i] = beta0 + beta1*x[i];
        }
    }
}
model{
    // Likelihood
    for(i in 1:n){
        y[i] ~ normal(mu[i],sigma);
    }
    // Priors

}
generated quantities{
    //  log-likelihood
    vector[n] log_likelihood;
  {
    for(i in 1:n){
      log_likelihood[i] = normal_lpdf(y[i] | mu[i], sigma);
    }
  }
  real log_lik;
  {
    log_lik = sum(log_likelihood);
  }
}
